<?php
include_once __DIR__.'/../framework/init.php';
include_once __DIR__.'/AcelleMail.php';
class AcelleWPWorkflowsRules {
	public $triggers = [];
	public $actions = [];
	public function __construct()
	{

		add_action('admin_menu', array($this, 'menu'));
		add_action( 'wp_ajax_get_trigger_options', array($this,'get_trigger_options'));
		add_action( 'wp_ajax_nopriv_get_trigger_options', array($this, 'get_trigger_options'));

		add_action( 'wp_ajax_get_action_options', array($this,'get_action_options'));
		add_action( 'wp_ajax_nopriv_get_action_options', array($this, 'get_action_options'));

		add_action( 'wp_ajax_add_new_rule', array($this,'addNewRule'));
		add_action( 'wp_ajax_nopriv_add_new_rule', array($this, 'addNewRule'));


		add_action( 'wp_ajax_post_rules', array($this,'postRule'));
		add_action( 'wp_ajax_nopriv_post_rules', array($this, 'postRule'));
		add_action( 'admin_enqueue_scripts', array( $this, 'scripts' ) );

		add_action('wp_head', array($this, 'ajaxurl'));

	}


	public function postRule()
	{
		
		$rules = sanitize_text_field(urldecode($_POST['rules']));
		parse_str(str_replace("\\'",'',($rules)), $output);
		$temp = [];
		foreach($output['frm_rule'] as $out) {
			$temp['frm_rule'][] = $out;
		}
		update_option('CAI_RULES', $temp);
		$res['status'] = true;
		$res['message'] = __('Workflows Saved Successfully', 'CAI');
		echo wp_send_json($res, 200);die;

	}

	public function menu()
	{
		add_submenu_page('acellewpemail-settings', __('WorkFlows', 'CAI'), __('WorkFlows', 'CAI'), 'manage_options', 'custom-acellemail-rules', array($this, 'addRules'));
	}

	public function ajaxurl()
	{
		echo '<script type="text/javascript">
		          var ajaxurl = "' . admin_url('admin-ajax.php') . '";
		        </script>';
	}

	public function scripts()
	{
		wp_enqueue_script(
			'select2-js',
			'https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js',
			array(
				'jquery',
			),
			1.0
		);

		wp_enqueue_script(
			'acelle-wp-admin-js',
			plugin_dir_url(__FILE__) . '../assets/js/acelle-wp.js',
			array(
				'jquery',
			),
			1.1
		);
		
		wp_enqueue_style(
			'acelle-wp-admin-css',
			plugin_dir_url(__FILE__) . '../assets/css/acelle-wp.css',
			array(), 1.0
		);
		wp_enqueue_style(
			'select2-css',
			'https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css',
			array(), 1.0
		);
	}

	public function get_trigger_options()
	{
		$savedRules = get_option('CAI_RULES');

		$trigger_index = sanitize_text_field($_POST['trigger_index']);
		$actIndex = sanitize_text_field($_POST['actIndex']);
		$triggers = $this->getTriggers();
		$triggers = $triggers[$trigger_index];

		$act = null;
		if ($savedRules && $savedRules['frm_rule'][$actIndex]) {
			if ($savedRules['frm_rule'][$actIndex]['trigger_option'] && $savedRules['frm_rule'][$actIndex]['trigger_option'][0]) {
				$act = $savedRules['frm_rule'][$actIndex]['trigger_option'][0];
				$actArr = $savedRules['frm_rule'][$actIndex]['trigger_option'];
			}
		}

		if ($triggers['trigger_ui_type'] == 'multiselect') {
			$html = '';
			$html .= '<tr class="inner_trigger_options">';
			$html .= '<th scope="row">'.$triggers['option_display_name']. '</th>';
			$html .= '<td>';
			$html .= ' <select name="frm_rule['.$actIndex.'][\'trigger_option\'][]" multiple>';
			foreach ($triggers['trigger_available_option'] as $opt):
				if (in_array($opt['key'], $actArr)) {
				$html .= ' <option selected="selected" value="'.$opt['key'].'">'.$opt['value'].'</option>';
				} else {
					$html .= ' <option value="' . $opt['key'] . '">' . $opt['value'] . '</option>';

				}
				
			endforeach;	

			$html .= '</select>';
			$html .= '<td>';
			$html .= '</tr>';	
		} else if ($triggers['trigger_ui_type'] == 'select') {
			$html = '';
			$html .= '<tr class="inner_trigger_options">';
			$html .= '<th scope="row">'.$triggers['option_display_name']. '</th>';
			$html .= '<td>';
			$html .= ' <select name="frm_rule['.$actIndex.'][\'trigger_option\'][]">';
			foreach ($triggers['trigger_available_option'] as $opt):
				if ($act == $opt['key']) {
				$html .= ' <option selected="selected" value="'.$opt['key'].'">'.$opt['value'].'</option>';
				} else {
					$html .= ' <option value="' . $opt['key'] . '">' . $opt['value'] . '</option>';

				}
				
			endforeach;	

			$html .= '</select>';
			$html .= '<td>';
			$html .= '</tr>';	
		} else if ($triggers['trigger_ui_type'] == 'input') {
			$html = '';
			$html .= '<tr class="inner_trigger_options">';
			$html .= '<th scope="row">'.$triggers['option_display_name']. '</th>';
			$html .= '<td>';
			if ($act) {
			$html .= '<input type="text" name="frm_rule['.$actIndex.'][\'trigger_option\'][]" value="'.$act.'"/>';

			} else {
			$html .= '<input type="text" name="frm_rule['.$actIndex.'][\'trigger_option\'][]" value="'.$triggers['option_default_value'].'"/>';

			}
			$html .= '<td>';
			$html .= '</tr>';	
		} else if ($triggers['trigger_ui_type'] == 'textarea') {
			$html = '';
			$html .= '<tr class="inner_trigger_options">';
			$html .= '<th scope="row">'.$triggers['option_display_name']. '</th>';
			$html .= '<td>';
			if ($act) {
				$html .= '<textarea name="frm_rule[' . $actIndex . '][\'trigger_option\'][]">' . $act . '</textarea>';
	
			} else {
				$html .= '<textarea name="frm_rule[' . $actIndex . '][\'trigger_option\'][]">' . $triggers['option_default_value'] . '</textarea>';

			}
			
			$html .= '<td>';
			$html .= '</tr>';	
		}
		
		echo $html;die;
	}

	public function get_action_options()
	{
		$savedRules = get_option('CAI_RULES');
		$action_index = sanitize_text_field($_POST['action_index']);
		$actIndex = sanitize_text_field($_POST['actIndex']);
		$actions = $this->getActions();
		$act=null;
		if ($savedRules && $savedRules['frm_rule'][$actIndex]) {
			if ($savedRules['frm_rule'][$actIndex]['action_option'] && $savedRules['frm_rule'][$actIndex]['action_option'][0]) {
				$act = $savedRules['frm_rule'][$actIndex]['action_option'][0];
			}
		}
		$actions = $actions[$action_index];
		
		if ($actions['actions_ui_type'] == 'select') {

			$html = '';
			$html .= '<tr class="inner_action_option">';
			$html .= '<th scope="row">'.$actions['option_display_name']. '</th>';
			$html .= '<td>';
			$html .= ' <select name="frm_rule['.$actIndex.'][\'action_option\'][]">';
			$html .= ' <option value="">'.$actions['option_display_name'].'</option>';
			foreach ($actions['actions_available_option'] as $opt):
				if ($act == $opt['key']) {
					$html .= ' <option selected="selected" value="'.$opt['key'].'">'.$opt['value'].'</option>';
				} else {
					$html .= ' <option  value="' . $opt['key'] . '">' . $opt['value'] . '</option>';
				}
				
			endforeach;	

			$html .= '</select>';
			$html .= '<td>';
			$html .= '</tr>';
		} else if($actions['actions_ui_type'] == 'input') {
			$html = '';
			$html .= '<tr class="inner_action_option">';
			$html .= '<th scope="row">' . $actions['option_display_name'] . '</th>';
			$html .= '<td>';
			if ($act){
				$html .= '<input type="text" name="frm_rule[' . $actIndex . '][\'action_option\'][]" value="' . $act . '"/>';
			} else {
				$html .= '<input type="text" name="frm_rule[' . $actIndex . '][\'action_option\'][]" value="' . $actions['option_default_value'] . '"/>';

			}
			
			$html .= '<td>';
			$html .= '</tr>';

		} else if($actions['actions_ui_type'] == 'textarea') {
			$html = '';
			$html .= '<tr class="inner_action_options">';
			$html .= '<th scope="row">' . $actions['option_display_name'] . '</th>';
			$html .= '<td>';
			if ($act) {
				$html .= '<textarea name="frm_rule[' . $actIndex . '][\'action_option\'][]">' . $act . '</textarea>';
			} else {
				$html .= '<textarea name="frm_rule[' . $actIndex . '][\'action_option\'][]">' . $actions['option_default_value'] . '</textarea>';
			}
			
			$html .= '<td>';
			$html .= '</tr>';

		}
		echo $html;die;

	}

	public function addRules()
	{

		$savedRules = get_option('CAI_RULES');

		$triggers = $this->getTriggers();
		$actions = $this->getActions();

		echo $this->render('rules', array('triggers'=>$triggers, 'actions'=>$actions, 'savedRules' => $savedRules));
		exit();
	
	}

	public function addNewRule() 
	{	
		$triggers = $this->getTriggers();
		$actions = $this->getActions();
		$actIndex = sanitize_text_field($_GET['actIndex']);

		echo $this->render('rules_table', array('triggers'=>$triggers, 'actions'=>$actions, 'actIndex'=>$actIndex));
		exit();
	}


	public function getTriggers()
	{
		$downloads = $this->getAllEDDProducts();
		$triggers[] = [
			'title' => __('New Wordpress Registration', 'CAI'),
			'trigger_slug'=>'trigger_wp_registration',
			'no_option' => true,
			'option_display_name' => '',
			'option_default_value' => '',
			'trigger_ui_type'=> '', // select, input, textarea 
			'trigger_available_option' => [] , // multiple option in case of select
		];
		$triggers[] = [
			'title'=> __('New EDD Product Purchase', 'CAI'),
			'trigger_slug'=>'trigger_edd_purchase',
			'no_option'=>false,
			'option_display_name' => __('Choose EDD Product', 'CAI'),
			'option_default_value' => '',
			'trigger_ui_type'=>'multiselect',
			'trigger_available_option' => $downloads
		];
		$triggers[] = [
			'title' => __('New EDD Subscription', 'CAI'),
			'trigger_slug' => 'trigger_new_edd_subscription',
			'no_option' => false,
			'option_display_name' => __('Choose EDD Product', 'CAI'),
			'option_default_value' => '',
			'trigger_ui_type' => 'multiselect',
			'trigger_available_option' => $downloads,
		];
		$edd_subscriptions_array = [
			['key'=>'Completed', 'value'=> 'Completed'],
			['key'=>'Expired', 'value'=> 'Expired'],
			['key'=>'Cancelled', 'value'=> 'Cancelled']
		];
		$triggers[] = [
			'title' => __('EDD Subscription Updated', 'CAI'),
			'trigger_slug' => 'trigger_edd_subscription_updated',
			'no_option' => false,
			'option_display_name' => __('Subscription Status', 'CAI'),
			'option_default_value' => '',
			'trigger_ui_type' => 'select',
			'trigger_available_option' => $edd_subscriptions_array,
		];

		$triggers = apply_filters('acellemail_wp_customize_trigger', $triggers);
		$this->triggers = $triggers;
		return $this->triggers;
	}

	public function getActions() 
	{
		$lists = $this->getAceMailLists();
		$actions[] = [
			'title' => __('Add to list','CAI'),
			'action_slug' => 'rule_add_acemail_list',
			'no_option' => false,
			'option_display_name' => __('Choose list','CAI'),
			'option_default_value' => '',
			'actions_ui_type'=> 'select', // select, input, textarea 
			'actions_available_option' => $lists , // multiple option in case of select
		];

		$actions[] = [
			'title' => __('Send Subscription Email','CAI'),
			'action_slug' => 'rule_send_subscription_email',
			'no_option' => false,
			'option_display_name' => __('Choose list','CAI'),
			'option_default_value' => '',
			'actions_ui_type'=> 'select', // select, input, textarea 
			'actions_available_option' => $lists , // multiple option in case of select
		];

		$actions[] = [
			'title' => __('Post to url', 'CAI'),
			'action_slug' => 'rule_post_acemail_endpoint',
			'no_option' => false,
			'option_display_name' => __('Enter endpoint', 'CAI'),
			'option_default_value' => '',
			'actions_ui_type' => 'input', // select, input, textarea
			'actions_available_option' => [], // multiple option in case of select
		];

		$actions = apply_filters('acellemail_wp_customize_action', $actions);
	
		$this->actions = $actions;
		return $this->actions;
	}

	private function getAllEDDProducts()
	{
		$args = array(
			'fields'        => 'ids',
        	'post_type'     => 'download',
			'no_found_rows' => true,
			'numberposts' => -1
		);
		$downloads = get_posts( $args );
		$downloadsArray = [];
		$downloadsArray[] = ['key'=>'', 'value'=>'Choose Products'];
		foreach ( $downloads as $key => $download_id ) {
			$download = new EDD_Download( $download_id );
			$downloadsArray[] = ['key'=>$download->ID, 'value'=>$download->post_title];
		}
		return $downloadsArray;

	}

	public function getAceMailLists()
	{
		$api_key = wp_get_page_field_value( 'acellewpemail-settings', 'acellemail_wp_api_key' );
		$end_point = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_endpoint' );
		$objAcelle = new AcelleMail($api_key, $end_point);
		$lists = $objAcelle->get_all_list();
		$listArray = [];
		if (isset($lists['error'])) {
			return $listArray;
		}
		if ($lists){
			foreach ($lists as $list){
				$listArray[] = ['key'=> $list['uid'], 'value' => $list['name']];
			}
		}
		return $listArray;
	}

	public static function render($view, $data = null)
    {
        // Handle data
        ($data) ? extract($data) : null;
 
        ob_start();
        include(plugin_dir_path(__FILE__).'../views/'.$view.'.php');
        $view = ob_get_contents();
        ob_end_clean();

        return $view;
    }

}
